<?php
	ini_set('display_errors','on');
	ini_set('include_path','../../');
	define("RACINE_WWW",realpath("../../")."/");
	
	include_once 'includes/Config.inc.php';
	function __autoload($class_name){
		require_once("classes/$class_name.class.php");
	}
	bdd::connect();
?>
<h5>
	Lot
	<span class="h5_recap" id="recap_lot"><%= selectedLot.nom %></span>
</h5>
<ul id="lots_container">
	
	<% for(var i in lots) { %>
		<li data-comptabilise='<%= lots[i].comptabilise %>' class='lot idClient_<%= lots[i].id_client %> idLot_<%= lots[i].id %> <%= lots[i].selected %>'>
			<% if(lots[i].comptabilise==1){%>
				<img src='img/folder_ok.png'/>
			<% } else { %>
				<img src='img/folder.png'/>
			<% } %>
			<span class="val_lot_nom"><%= lots[i].nom %></span>
		</li>
	<% } %>
	
	<li class="lot_new">
		<img src="img/folder_new.png" alt="Ajouter un lot"/>
		<span>Creer un nouveau lot</span>
	</li>
		
	<script>
		$("#lots_container .lot_new_cancel").hide();
	</script>
	
	<script>
		//Scripts changement de lot
	
		$(".lot").click(function(){
		
			$(".lot").removeClass("selected");
			$(this).addClass("selected");

			$("#recap_lot").html($(this).find("span.val_lot_nom").html());
			// Recup des variables dans la classe
			var lot = $(this).attr('class').match(/idLot_\d+/)[0];
				lot = lot.substring(lot.indexOf('_')+1,lot.lenght);
	
			$("#selectClient").trigger('updateLot',	[lot]);	

			if($(this).attr("data-comptabilise") == 1) {
				$("#detailLot").css("background-color","#FF9999");
			} else {
				$("#detailLot").css("background","none");
			}
		});
	</script>
	
	
</ul>

<!-- Crea lot-->
<form id="creaLot" method="post">
	<input type="hidden" name="action" value="addLot"/>
	<input type="hidden" name="idClient" value="<%= selectedLot.id_client %>"/>
	<script>
		$("#creaLot input[name='idClient']").val($("#selectClient").val());
	</script>
	<fieldset><legend>Creation du Lot</legend>

		<label for="nomLot">Nom du lot</label><br>
		<input required type="text" name="nomLot"/>
		<br/>
		<label for="tache">Type de tache</label><br>
		<select name="idTypeTache">
		<?php
			foreach(Lot::getTypesTache() as $tt)
				echo "<option value='".$tt['id']."'>".$tt['nom']."</option>";
		?>
		</select>
		
		<p style="color:#666">Parametres optionnels</p>

		<div style="margin-left:20px;border-left:thin solid #444;padding-left:10px;">
			<label for="forfait">Forfait</label><br>
			<input type="text" name="forfait"/>
			<br/>
			<label for="temps">Temps estime</label><br>
			<input type="temps" name="duree"/>
		</div>
	</fieldset>
	<fieldset><legend>Creation d'une Tache</legend>
		<label for="nomTache">Nom</label><br>
		<input required type="text" name="nomTache"/>
	</fieldset>

	<input type="submit" value="Valider"/>
	
	<img src="img/icones/Exit.png" alt="Annuler crea lot" class="lot_new_cancel" style="float:right;cursor:pointer;"/>
</form>

<script>
	// Scripts crealot
	$("#creaLot").bind({
		'appear':
			function(){
				$("#creaLot").show();
				$("#lots_container .lot_new").hide();
				$("#detailLot").hide();
			},
		'desappear':
			function(){
				$("#creaLot").hide();
				$("#lots_container .lot_new").show();
				$("#detailLot").show();
			}
	})
	.trigger("desappear");
	
	$("#lots_container .lot_new").click(function(){
		$("#creaLot").trigger("appear");
	});
	$(".lot_new_cancel").click(function(){
		$("#creaLot").trigger("desappear");
	});
	
</script>
<!--
<h1>
	<p style="color:#AAA">body :<span id="body"></span></p>
	<p style="color:#000">ul :<span id="ul"></span></p>
	<p style="color:green">li :<span id="li"></span></p>
	<p style="color:blue">img :<span id="img"></span></p>
</h1>
<script>
$(window).resize(function(){
	pos($("#body"),$("body"));
	pos($("#ul"),$("#lots_container"));
	pos($("#li"),$(".lot").eq(0));
	pos($("#img"),$(".lot img").eq(0));
});
function pos(id,elem){
	id.html("width("+elem.css('width')+"), height("+elem.css('height')+"), ");//min-width("+elem.css('min-width')+"), min-height("+elem.css('min-height')+"), max-width("+elem.css('max-width')+"), max-height("+elem.css('max-height')+")");
}
</script>
 -->

<div id="detailLot">
	
</div>


