<?php
//include_once 'modules/listes/classes/CListes.class.php';//auto
include_once 'modules/stats/services_flash/SvcStats.php';
//include_once 'modules/blog/classes/CBlogable.class.php';//auto

class CBlogableActions
{
	public static $ip='';
	public static $code_unique='';
	
	public static function genereTokenAntispam($id_liste, $id_elem, $nom_token = 'ANTISPAM_COMM_TOKEN')
	{
		$token = md5(rand().rand());
		
		ifReq("DELETE FROM blogable__unicite WHERE date_appel < (CURDATE() - INTERVAL 1 DAY) AND type_action = '$nom_token' AND blog_identifiant_liste = '$id_liste' AND id_auto_elem = $id_elem");
		CListes::insere('blog_unicite', array('blog_identifiant_liste'=>$id_liste,
													  'type_action'=>$nom_token, 'id_auto_elem'=>$id_elem,
													  'date_appel'=>date('Y-m-d H:i:s'), 'ip'=>'noIp',
													  'code_unique'=>$token));
		return $token;
	}
	
	/**
	 * sauve la note pour cet élement de liste
	 * @param $identifiant_liste
	 * @param $id_elem
	 * @param $note
	 * @return boolean
	 */
	public static function saveNote($identifiant_liste, $id_elem, $note)
	{
		$autorise = self::isAutorisee($identifiant_liste, $id_elem, 'note');
		if ($autorise)
		{
			CListes::insere('blog_unicite', array('blog_identifiant_liste'=>$identifiant_liste,
													  'type_action'=>'note', 'id_auto_elem'=>$id_elem,
													  'date_appel'=>date('Y-m-d H:i:s'), 'ip'=>self::$ip,
													  'code_unique'=>self::$code_unique));
			SvcStats::static_ajoutCptStatSimple($identifiant_liste.'_NOTE', $note, $id_elem);
			CListes::insere('blog_unicite', array('blog_identifiant_liste'=>$identifiant_liste,
													  'type_action'=>'vote', 'id_auto_elem'=>$id_elem,
													  'date_appel'=>date('Y-m-d H:i:s'), 'ip'=>self::$ip,
													  'code_unique'=>self::$code_unique));
			SvcStats::static_ajoutCptStatSimple($identifiant_liste.'_VOTE', 1, $id_elem);
			return true;
		}
		return false;
	}
	
	/**
	 * sauve le vote pour cet élément de la liste
	 * @param $identifiant_liste
	 * @param $id_elem
	 * @return boolean
	 */
	public static function saveVote($identifiant_liste, $id_elem)
	{
		$autorise = self::isAutorisee($identifiant_liste, $id_elem, 'vote');
		if ($autorise)
		{
			CListes::insere('blog_unicite', array('blog_identifiant_liste'=>$identifiant_liste,
													  'type_action'=>'vote', 'id_auto_elem'=>$id_elem,
													  'date_appel'=>date('Y-m-d H:i:s'), 'ip'=>self::$ip,
													  'code_unique'=>self::$code_unique));
			SvcStats::static_ajoutCptStatSimple($identifiant_liste.'_VOTE', 1, $id_elem);
			return true;
		}
		return false;
	}
	
	/**
	 * ajoute le commentaire à l'élément de la liste
	 * @param $identifiant_liste
	 * @param $id_elem
	 * @param $texte
	 * @param $nomprenom
	 * @param $mail
	 * @return boolean
	 */
	public static function saveCommentaire($identifiant_liste, $id_elem, $texte, $nomprenom, $mail, $actif=1)
	{
		CListes::traite_et_insere('blog_commentaire', array('blog_identifiant_liste'=>$identifiant_liste,
												  'id_auto_elem'=>$id_elem, 'texte'=>$texte,
												  'nom_prenom'=>$nomprenom, 'mail'=>$mail,
												  'ip'=>$_SERVER['REMOTE_ADDR'], 'actif'=>$actif));
		return SvcStats::static_ajoutCptStatSimple($identifiant_liste.'_COMMENTAIRE', 1, $id_elem);
	}
	
	public static function statsCommentaire_plusUn($identifiant_liste, $id_elem)
	{
		return SvcStats::static_ajoutCptStatSimple($identifiant_liste.'_COMMENTAIRE', 1, $id_elem);
	}
	
	/**
	 * ajoute la disponibilité du tag à cette liste
	 * @param $identifiant_liste
	 * @param $id_elem
	 * @param $tag_texte
	 * @return int
	 */
	public static function ajouteTagToListe($identifiant_liste, $id_elem, $tag_texte)
	{
		//TODO: manque le parametre 'nom_url'
		$tag = testReq3("SELECT * FROM blogable__tag WHERE blog_identifiant_liste = '$identifiant_liste' AND nom LIKE '$tag'");
		if ($tag === false) {
			CListes::insere('blog_tag', array('blog_identifiant_liste'=>$identifiant_liste, 'nom'=>$tag));
			$tag = testReq3("SELECT * FROM blogable__tag WHERE blog_identifiant_liste = '$identifiant_liste' AND nom LIKE '$tag'");
		}
		return $tag['id_auto'];
	}
	
	/**
	 * sauve une correspondance elem/tag avec le nom du tag
	 * @param $identifiant_liste
	 * @param $id_elem
	 * @param $tag_texte
	 * @return boolean
	 */
	public static function saveTagByNom($identifiant_liste, $id_elem, $tag_texte)
	{
		$id_tag = self::ajouteTagToListe($identifiant_liste, $id_elem, $tag_texte);
		return self::saveTagById($identifiant_liste, $id_elem, $id_tag);
	}
	
	/**
	 * sauve une corespondance elem/tag avec un tag_id
	 * @param $identifiant_liste
	 * @param $id_elem
	 * @param $tag_id
	 * @return boolean
	 */
	public static function saveTagById($identifiant_liste, $id_elem, $tag_id)
	{
		return CListes::insere('blog_tags_elem', array('blog_identifiant_liste'=>$identifiant_liste, 'id_auto_elem'=>$id_elem, 'id_tag'=>$tag_id));
	}
	
	/**
	 * l'action est-elle autorisée pour cette élément d'une liste par cette personne
	 * @param $identifiant_liste
	 * @param $id_elem
	 * @param $action : 'vote ou 'note' pour l'instant
	 * @return boolean
	 */
	public static function isAutorisee($identifiant_liste, $id_elem, $action)
	{
		$infos = CBlogable::getInfos($identifiant_liste);
		$nbmax = $infos['nb_vote_autorise_jour'];
		self::$ip = $_SERVER['REMOTE_ADDR'];
		if ($infos['methode_unicite'] == 'session')
		{
			if (isset($_SESSION['blogable']['code_unique'])) self::$code_unique = $_SESSION['blogable']['code_unique'];
			else 
			{
				self::$code_unique = md5(genereCode(10));
				$_SESSION['blogable']['code_unique'] = self::$code_unique;
			}
			$where = "code_unique = '".self::$code_unique."'";
		}
		else //methode = 'ip'
		{
			self::$code_unique = 0;
			$where = "ip = '".self::$ip."'";
		}
		$autorise = false;
		if ($nbmax > 0)
		{
			$deja_fait = testReq3("SELECT COUNT(*) AS nb
								   FROM blogable__unicite
								   WHERE blog_identifiant_liste = '$identifiant_liste' AND id_auto_elem = $id_elem AND type_action = '$action'
								   AND date_appel >= '".date('Y-m-d')."' AND $where");
			
			if ($deja_fait === false || $deja_fait['nb'] < $nbmax) $autorise = true;
			else $autorise = false;
		}
		else $autorise = true;
		return $autorise;
	}
	
}


?>