<?php

class FrontController{
	
	private $defaut = array('module' => 'clients', 'action' => 'index');
	
	protected $request;
	
	private $template;
	private $contenuModule;
	
	private static $instance = null;
	
	
	public function __construct(){
		$this->request = new Request();
		
		$params = $this->request->route();
		$params = array_merge($this->defaut, $params);
		
                if (array_key_exists('HTTP_X_REQUESTED_WITH', $_SERVER) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
                    // Traitement pour une réponse Ajax
                    $ajax = new Ajax($this->request);
                }
                else{
                    $this->forward($params['module'],$params['action']);
                }
	}
	
	
	public function forward($module,$action){
                $module = strtolower($module);
                $ModuleController = 'Controller'.ucfirst($module);
            
		$dir = RACINE_INCLUDE.'modules/'.$module.'/actions/'.$ModuleController.'.class.php';
		
		if(is_readable($dir)){
			require_once($dir);
			
			$this->contenuModule = new $ModuleController($this->request,$action);
			
			$view = new View();
			$view->setModule($this->contenuModule);
			$this->template = $view->render('../tpl/layout.php');
		}
		else{
			exit('Pas de module correspondant');
		}
	}
	
	public static function getInstance()
    {
        if (is_null(self::$instance)){
            self::$instance = new self();
        }
        return self::$instance;
    }
	
	
	public function dispatch(){
		echo $this->template;
	}
	
	
}


?>