<?php 
// 	$live  = Live :: getInstance();
	
	$userId = Identification :: getId();
	if(isset($_SESSION['last_user_id_ticket']))
		$userId = $_SESSION['last_user_id_ticket'];
	
	// Récupération des utilisateurs à assigner
	$tabUsers = bdd :: getResults("SELECT id, nom, couleur FROM wrk_users WHERE actif = 1");
	array_unshift($tabUsers, array("id"=>0, "nom"=>'Tous'));
	
	// Récupération des clients
	$tabClients = bdd :: getResults("SELECT * FROM wrk_clients WHERE actif = 1");
	array_unshift($tabClients, array("id"=>'all', "nom"=>'Tous'));
	$selectedClient = (isset($_SESSION['idClientFiltreTickets'])) ? $_SESSION['idClientFiltreTickets'] : 'all';
	
	// Récupération du filtre de propriétés
	$tabPrio = Ticket :: $tabPriorites;
	array_unshift($tabPrio, array("lvl-priorite"=>"all", "txt-priorite"=>'Toutes'));
	$selectedPriorite = (isset($_SESSION['idPrioriteFiltreTickets'])) ? $_SESSION['idPrioriteFiltreTickets'] : 'all';
	
	// Récupération du filtre de statuts
	$tabSelectedStatuts = (isset($_SESSION['tabIdStatuts'])) ? $_SESSION['tabIdStatuts'] : Ticket :: getInfosStatutAuto(Ticket :: STATUT_AUTO_TODO, 'tab-lvls');
?>

<div id="main-content-home">
	<div id="content-form-filtres">
		<form method="post">
			<h2 class="txt-to-bottom" id="titre-content-filtres">Filtres</h2>
			
			<div id="content-filtres-tickets">
				<div id="content-filtre-user-assign">
					<label class="titre-filtre" for="tickets-user-select">Afficher les tickets de :</label>
					<select id="tickets-user-select" name="idUserTickets">
					<?php 
						echo TicketModel :: getOptionsAndSelected($tabUsers, 'id', 'nom', $userId);
					?>
					</select>
				</div>
				
				<div id="content-filtre-client">
					<label class="titre-filtre" for="tickets-client-select">Client : </label>
					<select id="tickets-client-select" name="idClient">
					<?php 
						echo TicketModel :: getOptionsAndSelected($tabClients, 'id', 'nom', $selectedClient);
					?>
					</select>
				</div>
				
				<div id="content-filtre-priorite">
					<label class="titre-filtre" for="tickets-prio-select">Priorité : </label>
					<select id="tickets-prio-select" name="idPrioriteFiltreTickets">
					<?php 
						echo TicketModel :: getOptionsAndSelected($tabPrio, 'lvl-priorite', 'txt-priorite', $selectedPriorite);
					?>
					</select>
				</div>
				
				<div id="content-filtre-statuts-auto">
					<span class="titre-filtre">Statuts Auto : </span>
					<?php 
						echo TicketModel :: getBtnStatutsAuto();
					?>
				</div>
				
				<div id="content-filtre-statut">
					<span class="titre-filtre">Statuts : </span>
					<span id="content-check-statut">
					<?php 
						echo TicketModel :: getStatutsCheckbox($tabSelectedStatuts);
					?>
					</span>
				</div>
			</div>
			
			<script>
			$('#tickets-prio-select, #tickets-user-select, #tickets-client-select, #content-check-statut input[type="checkbox"]').live('change', function(){
			//	console.info($(this));
				var tabIdStatuts = new Array;
				$('#content-check-statut input[type="checkbox"]:checked').each(function(){
					tabIdStatuts.push($(this).val());
				});
				
				$.ajax({
					type : "POST",
					url : "ajax.php",
					dataType : "html",
					data : {
						action: "ajaxGetTplUserTickets",
						idUser: $("#tickets-user-select").val(),
						idClient: $("#tickets-client-select").val(),
						idPrioriteFiltreTickets: $("#tickets-prio-select").val(),
						tabIdStatuts: tabIdStatuts
					}
				}).done(function(html) {
					$('#content-user-tickets').empty().append(html);
				}).fail(function(jqXHR, textStatus) {
					alert("<h1>Erreur Ajax : "+textStatus+"<h1>");
				});
			});
			</script>
		</form>
	</div>
	
	<div id="content-user-tickets">
		<?php echo TicketModel :: getTplUserTickets(); ?>
	</div>
</div>